<?php

namespace Modules\Training\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TrainingSchedule extends Model 
{

    protected $table = 'training_schedules';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function training()
    {
        return $this->belongsTo('Training');
    }

    public function enrolled_training()
    {
        return $this->hasMany('EnrolledTraining', 'schedule_id');
    }

}